/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.service;

import itx.erp.base.service.MetaService;
import itx.erp.customer.model.Customer;
import itx.erp.customer.service.CustomerService;
import itx.erp.exception.ObjectNotFoundException;
import itx.erp.sales.model.Offer;
import itx.erp.sales.model.OfferLine;
import itx.erp.sales.model.Order;
import itx.erp.sales.model.OrderLine;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.service.ServiceBase;
import jtbcore.util.MapUtil;

public class OrderService
extends ServiceBase {
    protected CustomerService customerService;
    protected MetaService metaService;

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public List<String> listOrderStatus() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("open");
        l.add("paid");
        l.add("invoiced");
        l.add("cancelled");
        return l;
    }

    public QueryResult<Order> searchOrders(Map<String, Object> opts) throws SQLException {
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("sales__order");
        b.addSelectField("sales__order", "order_id");
        b.addSelectField("sales__order", "customer_id");
        b.addSelectField("sales__order", "order_date");
        b.addSelectField("sales__order", "order_status");
        b.addSelectField("sales__order", "order_number");
        b.addSelectField("sales__order", "subject");
        b.addSelectField("sales__order", "total_calculated_price");
        b.addSelectField("sales__order", "total_calculated_price_incl_vat");
        b.addSelectField("sales__order", "edited");
        b.addSelectField("sales__order", "created");
        b.addSelectField("customer__customer", "customer_name");
        b.addLeftJoin("customer__customer", "customer__customer.customer_id = sales__order.customer_id");
        if (MapUtil.hasProperty(opts, "q")) {
            String q = opts.get("q").toString().trim();
            b.addWhere(" customer__customer.customer_name like ? or sales__order.order_number like ? or sales__order.subject like ?", "%" + q + "%", "%" + q, "%" + q + "%");
        }
        b.setRawOrderBy("order_id desc");
        ResultSet rs = b.queryResultSet();
        QueryResult<Order> qr = new QueryResult<Order>();
        if (opts.containsKey("start")) {
            qr.setStart((Integer)opts.get("start"));
        }
        if (opts.containsKey("pageSize")) {
            qr.setPageSize((Integer)opts.get("pageSize"));
        }
        qr.fill(Order.class, rs);
        rs.close();
        return qr;
    }

    public Order readOrder(Integer orderId) throws SQLException, JTBException {
        Order o = (Order)this.queryToObject(Order.class, "select * from sales__order where order_id = ?", orderId);
        if (o == null) {
            throw new ObjectNotFoundException("Order not found");
        }
        List l = this.queryToList(OrderLine.class, "select * from sales__order_line where order_id = ? order by sort", orderId);
        o.setLines(l);
        if (o.getCustomerId() != null) {
            Customer cust = this.customerService.readCustomer(o.getCustomerId());
            o.setCustomer(cust);
        }
        return o;
    }

    public Integer saveOrder(Order ord) throws IOException, SQLException, JTBException {
        Order oldOrder = null;
        if (ord.getOrderId() != null) {
            oldOrder = this.readOrder(ord.getOrderId());
        }
        if (ord.getOrderNumber() == null) {
            Integer newOrderNo = (Integer)this.connection.queryValue("select max(order_number) from sales__order", Integer.class, new Object[0]);
            newOrderNo = newOrderNo == null || newOrderNo == 0 ? 1000 : newOrderNo + 1;
            ord.setOrderNumber(newOrderNo);
        }
        long totalExclVat = 0L;
        long totalInclVat = 0L;
        for (OrderLine ol : ord.getLines()) {
            if ("text".equals(ol.getLineType())) continue;
            Double et = 0.0;
            if (ol.getAmount() != null && ol.getPriceExclVat() != null) {
                et = ol.getAmount() * ol.getPriceExclVat() * 100.0;
            }
            totalExclVat += (long)et.intValue();
            Double it = 0.0;
            if (ol.getAmount() != null && ol.getPriceInclVat() != null) {
                it = ol.getAmount() * ol.getPriceInclVat() * 100.0;
            }
            totalInclVat += (long)it.intValue();
        }
        ord.setTotalCalculatedPrice((double)totalExclVat / 100.0);
        ord.setTotalCalculatedPriceInclVat((double)totalInclVat / 100.0);
        Integer orderId = this.connection.save("sales__order", "order_id", ord.getBaseStringMap());
        ord.setOrderId(orderId);
        List<OrderLine> lines = ord.getLines();
        int x = 0;
        while (x < lines.size()) {
            Integer oldLineId = null;
            if (oldOrder != null && x < oldOrder.getLines().size()) {
                oldLineId = oldOrder.getLines().get(x).getOrderLineId();
            }
            OrderLine newLine = lines.get(x);
            newLine.setOrderLineId(oldLineId);
            newLine.setOrderId(orderId);
            this.connection.save("sales__order_line", "order_line_id", newLine.getBaseStringMap());
            ++x;
        }
        if (oldOrder != null) {
            while (x < oldOrder.getLines().size()) {
                Integer olid = oldOrder.getLines().get(x).getOrderLineId();
                this.connection.query("delete from sales__order_line where order_line_id = ?", olid);
                ++x;
            }
        }
        return orderId;
    }

    public void deleteOrder(Integer orderId) throws IOException, SQLException, JTBException {
        Order ord = this.readOrder(orderId);
        this.connection.query("delete from sales__order_line where order_id = ?", orderId);
        this.connection.query("delete from sales__order where order_id = ?", orderId);
    }

    public Order createOrder(Offer of) throws IOException, SQLException, JTBException {
        Order or = new Order();
        or.setSubject(of.getSubject());
        or.setOrderDate(new Date());
        or.setCustomerId(of.getCustomerId());
        or.setInternalNote(of.getInternalNote());
        ArrayList<OrderLine> orls = new ArrayList<OrderLine>();
        for (OfferLine ol : of.getLines()) {
            OrderLine orl = new OrderLine();
            orl.setLineType(ol.getLineType());
            orl.setArticleId(ol.getArticleId());
            orl.setAmount(ol.getAmount());
            orl.setPriceExclVat(ol.getPriceExclVat());
            orl.setPriceInclVat(ol.getPriceInclVat());
            orl.setVatPercentage(ol.getVatPercentage());
            orl.setShortDescription(ol.getShortDescription());
            orls.add(orl);
        }
        or.setLines(orls);
        this.saveOrder(or);
        this.metaService.addMeta(Order.class.getName(), or.getOrderId(), "offerId", of.getOfferId().toString());
        return or;
    }

    public List<Order> listByOffer(Integer offerId) throws SQLException, JTBException {
        String sql = "select * from sales__order where order_id in (select object_id  from base__object_meta  where object_key = ?  and object_name = 'offerId' and object_value = ? )";
        List orders = this.queryToList(Order.class, sql, Order.class.getName(), offerId);
        return orders;
    }
}

